/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.crate;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.crate.ConstantCount;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.resource.crate.ICountFunctionAdapter;
import dev.toma.gunsrpg.resource.crate.RandomCount;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public final class CountFunctionRegistry {
    public static final ResourceLocation CONST = GunsRPG.makeResource("const");
    public static final ResourceLocation RNG = GunsRPG.makeResource("rng");
    private static final Map<ResourceLocation, ICountFunctionAdapter<?>> REGISTRY = new HashMap();

    public static void registerFunction(ResourceLocation identifier, ICountFunctionAdapter<?> adapter) {
        REGISTRY.put(identifier, adapter);
    }

    public static <F extends ICountFunction> ICountFunctionAdapter<F> findByKey(ResourceLocation identifier) {
        return REGISTRY.get(identifier);
    }

    public static <F extends ICountFunction> void encode(F function, PacketBuffer buffer) {
        ResourceLocation id = function.getId();
        buffer.func_192572_a(id);
        ICountFunctionAdapter<F> adapter = CountFunctionRegistry.findByKey(id);
        adapter.encode(function, buffer);
    }

    public static <F extends ICountFunction> F decode(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ICountFunctionAdapter<F> adapter = CountFunctionRegistry.findByKey(id);
        return adapter.decode(buffer);
    }

    static {
        CountFunctionRegistry.registerFunction(CONST, new ConstantCount.Adapter());
        CountFunctionRegistry.registerFunction(RNG, new RandomCount.Adapter());
    }
}

